#!/bin/sh
# Stream via ffmpeg, crtmpserver and jwplayer
# ---------------------------------------------------

myip=0.0.0.0
port=6666
width=320
height=240
fr=10

# Works with ffserver
# fr=25
# ffmpeg -f video4linux2 -s ${width}x${height} -r $fr -i /dev/video0 http://localhost:8090/webcam.ffm
# exit 0

# RTP Streaming with crtmpserver

# Test 1: good, but a bit behind (2-4 seconds)
# fr=25
# ffmpeg -f video4linux2 -s ${width}x${height} -r $fr -i /dev/video0 -intra -qscale 2 -f flv -metadata streamName=myStream tcp://0.0.0.0:6666
# exit 0

# Test 2: Good quality and only slightly behind
# fr=30
# ffmpeg -f video4linux2 -s ${width}x${height} -r $fr -i /dev/video0 -f flv -qscale 2 -metadata streamName=myStream tcp://0.0.0.0:6666
	
# Test 3: very good - very small latency
# After reading http://trac.ffmpeg.org/wiki/StreamingGuide
# fr=30
#ffmpeg -f video4linux2 -s ${width}x${height} -r $fr \
#	-async 1 -ab 24k -ar 22050 -bufsize 3000k -maxrate 750k \
#	-i /dev/video0 -intra -qscale 2 -f flv \
#	-metadata streamName=myStream tcp://0.0.0.0:6666
	
# Test 4: not much improvement
# After reading http://trac.ffmpeg.org/wiki/StreamingGuide
# fr=25
# ffmpeg -f video4linux2 -s ${width}x${height} -r $fr \
# 	-b 1k -ac 0 \
# 	-async 1 -bufsize 3000k -maxrate 750k \
# 	-i /dev/video0 -qscale 2 -f flv \
# 	-metadata streamName=myStream tcp://0.0.0.0:6666
	
# Test 5: very stable, but has 5 second delay which builds from .5 second delay at start, then stabilizes at 5 sec.
# ffmpeg -f video4linux2 -s 320x240 -r 21 \
# 	-i /dev/video0 \
# 	-ac 0 -me_method zero \
#  	-qscale 2 \
# 	-s 320x240 -r 23\
#	-b 1250k -bufsize 2000k -maxrate 1750k \
#	-f flv -metadata streamName=myStream tcp://0.0.0.0:6666
# exit 0
	
# Test 6: crtmpserver example - doesn't work
# ffmpeg -f video4linux2 -s 320x240 -r 21 \
#	-i /dev/video0 \
#	-vcodec mpeg4 \
#	-b 500000 -s 320x180 -strict experimental -g 25 -me_method zero \
#	-acodec aac -ab 96000 -ar 48000 -ac 2 -vbsf h264_mp4toannexb \
#	-f mpegts -metadata streamName=myStream tcp://0.0.0.0:9999
	
# Test 7: crtmpserver example: streams mpeg4 but it never reaches browser
# ffmpeg -f video4linux2 -s 320x240 -r 21 \
# 	-i /dev/video0 \
# 	-vcodec mpeg4 \
# 	-b 500000 -s 320x180 -strict experimental -g 25 -me_method zero \
# 	-f mpegts -metadata streamName=myStream udp://0.0.0.0:9999
# exit 0
	
# Test 8: Best
# ffmpeg -f video4linux2 -s 160x120 -r 25 \
# 	-i /dev/video0 \
# 	-ac 0 -me_method zero \
#	-qscale 1.25 \
#	-s 160x120 -r 25\
#	-b 1750k -bufsize 2000k -maxrate 2000k \
#	-f flv -metadata streamName=myStream tcp://0.0.0.0:6666
# exit 0

# Test 8: Best
ffmpeg -f video4linux2 -s 160x120 -r 25 \
	-i /dev/video0 \
	-ac 0 -me_method zero \
 	-qscale 1.1 \
	-s 160x120 -r 10\
	-b 1750k -bufsize 2000k -maxrate 2000k \
	-f flv -metadata streamName=myStream tcp://0.0.0.0:6666
exit 0
